# This file maps the CMSIS project options to toolchain settings.
#
#   - Applies to toolchain: LLVM/Clang Bare Metal Toolchain for the Arm Architecture 16.0.0 and greater

############### EDIT BELOW ###############
# Set base directory of toolchain
set(TOOLCHAIN_ROOT)
set(TOOLCHAIN_VERSION "16.0.0")

############ DO NOT EDIT BELOW ###########

set(AS "clang")
set(CC "clang")
set(CXX "clang++")
set(CPP "clang")
set(OC "llvm-objcopy")

if(DEFINED REGISTERED_TOOLCHAIN_ROOT)
  set(TOOLCHAIN_ROOT "${REGISTERED_TOOLCHAIN_ROOT}")
endif()
if(DEFINED REGISTERED_TOOLCHAIN_VERSION)
  set(TOOLCHAIN_VERSION "${REGISTERED_TOOLCHAIN_VERSION}")
endif()

if(DEFINED TOOLCHAIN_ROOT)
  set(PREFIX)
  set(EXT )
  
  set(AS ${TOOLCHAIN_ROOT}/${PREFIX}${AS}${EXT})
  set(CC ${TOOLCHAIN_ROOT}/${PREFIX}${CC}${EXT})
  set(CXX ${TOOLCHAIN_ROOT}/${PREFIX}${CXX}${EXT})
  set(CPP ${TOOLCHAIN_ROOT}/${PREFIX}${CPP}${EXT})
  set(OC ${TOOLCHAIN_ROOT}/${PREFIX}${OC}${EXT})
endif()

# Helpers

function(cbuild_set_defines lang defines)
  set(TMP_DEFINES)
  foreach(DEFINE ${${defines}})
    string(REPLACE "\"" "\\\"" ENTRY ${DEFINE})
    string(REGEX REPLACE "=.*" "" KEY ${ENTRY})
    if (KEY STREQUAL ENTRY)
      set(VALUE "1")
    else()
      string(REGEX REPLACE ".*=" "" VALUE ${ENTRY})
    endif()
    string(APPEND TMP_DEFINES "-D${ENTRY} ")
  endforeach()
  set(${defines} ${TMP_DEFINES} PARENT_SCOPE)
endfunction()

set(OPTIMIZE_VALUES       "debug" "none" "balanced" "size" "speed")
set(OPTIMIZE_CC_FLAGS     "-Og"   "-O0"  "-O2"      "-Os" "-O3")
set(OPTIMIZE_AS_FLAGS     ${OPTIMIZE_CC_FLAGS})
set(OPTIMIZE_CXX_FLAGS    ${OPTIMIZE_CC_FLAGS})
set(OPTIMIZE_LD_FLAGS     ${OPTIMIZE_CC_FLAGS})

set(DEBUG_VALUES          "on"      "off")
set(DEBUG_CC_FLAGS        "-g3"     "-g0")
set(DEBUG_CXX_FLAGS       ${DEBUG_CC_FLAGS})
set(DEBUG_LD_FLAGS        ${DEBUG_CC_FLAGS})
set(DEBUG_AS_FLAGS        ${DEBUG_CC_FLAGS})

set(WARNINGS_VALUES       "on"     "off")
set(WARNINGS_CC_FLAGS     ""       "-w")
set(WARNINGS_AS_FLAGS     ""       "-w")
set(WARNINGS_CXX_FLAGS    ""       "-w")
set(WARNINGS_LD_FLAGS     ""       "-w")

set(LANGUAGE_VALUES       "c90"      "gnu90"      "c99"      "gnu99"      "c11"      "gnu11"      "c++98"      "gnu++98"      "c++03"      "gnu++03"      "c++11"      "gnu++11"      "c++14"      "gnu++14"      "c++17"      "gnu++17"      "c++20"      "gnu++20"     )
set(LANGUAGE_CC_FLAGS     "-std=c90" "-std=gnu90" "-std=c99" "-std=gnu99" "-std=c11" "-std=gnu11" ""           ""             ""           ""             ""           ""             ""           ""             ""           ""             ""           ""            )
set(LANGUAGE_CXX_FLAGS    ""         ""           ""         ""           ""         ""           "-std=c++98" "-std=gnu++98" "-std=c++03" "-std=gnu++03" "-std=c++11" "-std=gnu++11" "-std=c++14" "-std=gnu++14" "-std=c++17" "-std=gnu++17" "-std=c++20" "-std=gnu++20")

function(cbuild_set_option_flags lang option value flags)
  if(NOT DEFINED ${option}_${lang}_FLAGS)
    return()
  endif()
  list(FIND ${option}_VALUES "${value}" _index)
  if (${_index} GREATER -1)
    list(GET ${option}_${lang}_FLAGS ${_index} flag)
    set(${flags} "${flag} ${${flags}}" PARENT_SCOPE)
  elseif(NOT value STREQUAL "")
    string(TOLOWER "${option}" _option)
    message(FATAL_ERROR "unkown '${_option}' value '${value}' !")
  endif()
endfunction()

function(cbuild_set_options_flags lang optimize debug warnings language flags)
  set(opt_flags)
  # GCC provide a better optimization level for debug
  if ((debug STREQUAL "on") AND (optimize STREQUAL ""))
    set(optimize "debug")
  endif()
  cbuild_set_option_flags(${lang} OPTIMIZE "${optimize}" opt_flags)
  cbuild_set_option_flags(${lang} DEBUG    "${debug}"    opt_flags)
  cbuild_set_option_flags(${lang} WARNINGS "${warnings}" opt_flags)
  cbuild_set_option_flags(${lang} LANGUAGE "${language}" opt_flags)
  set(${flags} "${opt_flags} ${${flags}}" PARENT_SCOPE)
endfunction()

if(CPU STREQUAL "Cortex-M0")
  set(CLANG_ARCH "armv6m")
  set(CLANG_ARCH_SUFFIX "_soft_nofp")
  set(CLANG_CPU "-mcpu=cortex-m0")  
elseif(CPU STREQUAL "Cortex-M0+")
  set(CLANG_ARCH "armv6m")
  set(CLANG_ARCH_SUFFIX "_soft_nofp")
  set(CLANG_CPU "-mcpu=cortex-m0plus")
elseif(CPU STREQUAL "Cortex-M1")
  set(CLANG_ARCH "armv6m")
  set(CLANG_ARCH_SUFFIX "_soft_nofp")
  set(CLANG_CPU "-mcpu=cortex-m1")
elseif(CPU STREQUAL "Cortex-M3")
  set(CLANG_ARCH "armv7m")
  set(CLANG_ARCH_SUFFIX "_soft_nofp")
  set(CLANG_CPU "-mcpu=cortex-m3")
elseif(CPU STREQUAL "Cortex-M4")
  set(CLANG_ARCH "armv7em")  
  if(FPU STREQUAL "SP_FPU")
    set(CLANG_ARCH_SUFFIX "_hard_fpv4_sp_d16")
    set(CLANG_CPU "-mcpu=cortex-m4 -mfpu=fpv4-sp-d16 -mfloat-abi=hard")
  else()
    set(CLANG_ARCH_SUFFIX "_soft_nofp")
    set(CLANG_CPU "-mcpu=cortex-m4")
  endif()
elseif(CPU STREQUAL "Cortex-M7")
  set(CLANG_ARCH "armv7em")
  if(FPU STREQUAL "DP_FPU")
    set(CLANG_ARCH_SUFFIX "_hard_fpv5_d16")
    set(CLANG_CPU "-mcpu=cortex-m7 -mfpu=fpv5-d16 -mfloat-abi=hard")
  elseif(FPU STREQUAL "SP_FPU")
    set(CLANG_ARCH_SUFFIX "_hard_fpv4_sp_d16")
    set(CLANG_CPU "-mcpu=cortex-m7 -mfpu=fpv5-sp-d16 -mfloat-abi=hard")
  else()
    set(CLANG_ARCH_SUFFIX "_soft_nofp")
    set(CLANG_CPU "-mcpu=cortex-m7")
  endif()
elseif(CPU STREQUAL "Cortex-M23")
  set(CLANG_ARCH "armv8m.main")
  set(CLANG_ARCH_SUFFIX "_soft_nofp")
  set(CLANG_CPU "-mcpu=cortex-m23")
elseif(CPU STREQUAL "Cortex-M33")
  set(CLANG_ARCH "armv8m.main")
  if(FPU STREQUAL "SP_FPU")
    set(CLANG_ARCH_SUFFIX "_hard_fp")
    if(DSP STREQUAL "DSP")
      set(CLANG_CPU "-mcpu=cortex-m33 -mfpu=fpv5-sp-d16 -mfloat-abi=hard")
    else()
      set(CLANG_CPU "-mcpu=cortex-m33+nodsp -mfpu=fpv5-sp-d16 -mfloat-abi=hard")
    endif()
  else()
    set(CLANG_ARCH_SUFFIX "_soft_nofp")
    if(DSP STREQUAL "DSP")
      set(CLANG_CPU "-mcpu=cortex-m33")
    else()
      set(CLANG_CPU "-mcpu=cortex-m33+nodsp")
    endif()
  endif()
elseif(CPU STREQUAL "Cortex-M35P")
  set(CLANG_ARCH "armv8m.main")
  if(FPU STREQUAL "SP_FPU")
    set(CLANG_ARCH_SUFFIX "_hard_fp")
    if(DSP STREQUAL "DSP")
      set(CLANG_CPU "-mcpu=cortex-m35p -mfpu=fpv5-sp-d16 -mfloat-abi=hard")
    else()
      set(CLANG_CPU "-mcpu=cortex-m35p+nodsp -mfpu=fpv5-sp-d16 -mfloat-abi=hard")
    endif()
  else()
    set(CLANG_ARCH_SUFFIX "_soft_nofp")
    if(DSP STREQUAL "DSP")
      set(CLANG_CPU "-mcpu=cortex-m35p")
    else()
      set(CLANG_CPU "-mcpu=cortex-m35p+nodsp")
    endif()
  endif()
elseif(CPU STREQUAL "Cortex-M55")
  set(CLANG_ARCH "armv8.1m.main")
  if(FPU STREQUAL "NO_FPU")
    if(MVE STREQUAL "NO_MVE")
      set(CLANG_ARCH_SUFFIX "_soft_nofp_nomve")
      set(CLANG_CPU "-mcpu=cortex-m55+nofp+nomve")
    else()
      set(CLANG_ARCH_SUFFIX "_hard_nofp_mve") 
      set(CLANG_CPU "-mcpu=cortex-m55+nofp")
    endif()
  else()
    set(CLANG_ARCH_SUFFIX "_hard_fp") 
    if(MVE STREQUAL "NO_MVE")
      set(CLANG_CPU "-mcpu=cortex-m55+nomve -mfloat-abi=hard")
    elseif(MVE STREQUAL "MVE")
      set(CLANG_CPU "-mcpu=cortex-m55+nomve.fp -mfloat-abi=hard")
    else()
      set(CLANG_CPU "-mcpu=cortex-m55 -mfloat-abi=hard")
    endif()
  endif()
elseif(CPU STREQUAL "Cortex-M85")
  set(CLANG_ARCH "armv8.1m.main")
  if(FPU STREQUAL "NO_FPU")
    if(MVE STREQUAL "NO_MVE")
      set(CLANG_ARCH_SUFFIX "_soft_nofp_nomve")
      set(CLANG_CPU "-mcpu=cortex-m85+nofp+nomve")
    else()
      set(CLANG_ARCH_SUFFIX "_hard_nofp_mve") 
      set(CLANG_CPU "-mcpu=cortex-m85+nofp")
    endif()
  else()
    set(CLANG_ARCH_SUFFIX "_hard_fp") 
    if(MVE STREQUAL "NO_MVE")
      set(CLANG_CPU "-mcpu=cortex-m85+nomve -mfloat-abi=hard")
    elseif(MVE STREQUAL "MVE")
      set(CLANG_CPU "-mcpu=cortex-m85+nomve.fp -mfloat-abi=hard")
    else()
      set(CLANG_CPU "-mcpu=cortex-m85 -mfloat-abi=hard")
    endif()
  endif()
elseif(CPU STREQUAL "Cortex-A5")
  message(FATAL_ERROR "${CPU} not supprted!")
  if(FPU STREQUAL "DP_FPU")
    set(CLANG_CPU "-mcpu=cortex-a5+nosimd -mfpu=auto -mfloat-abi=hard")
  else()
    set(CLANG_CPU "-mcpu=cortex-a5+nosimd+nofp")
  endif()
elseif(CPU STREQUAL "Cortex-A7")
  message(FATAL_ERROR "${CPU} not supprted!")
  if(FPU STREQUAL "DP_FPU")
    set(CLANG_CPU "-mcpu=cortex-a7+nosimd -mfpu=auto -mfloat-abi=hard")
  else()
    set(CLANG_CPU "-mcpu=Cortex-a7+nosimd+nofp")
  endif()
elseif(CPU STREQUAL "Cortex-A9")
  message(FATAL_ERROR "${CPU} not supprted!")
  if(FPU STREQUAL "DP_FPU")
    set(CLANG_CPU "-mcpu=cortex-a9+nosimd -mfpu=auto -mfloat-abi=hard")
  else()
    set(CLANG_CPU "-mcpu=cortex-a9+nosimd+nofp")
  endif()
endif()
if(NOT DEFINED CLANG_CPU)
  message(FATAL_ERROR "Error: CPU is not supported!")
endif()

# Assembler

set(ASM_CPU "${CLANG_CPU}")
set(ASM_DEFINES ${DEFINES})
cbuild_set_defines(ASM ASM_DEFINES)

set(ASM_OPTIONS_FLAGS)
cbuild_set_options_flags(ASM "${OPTIMIZE}" "${DEBUG}" "${WARNINGS}" "" ASM_OPTIONS_FLAGS)

if(BYTE_ORDER STREQUAL "Little-endian")
  set(ASM_BYTE_ORDER "-mlittle-endian")
elseif(BYTE_ORDER STREQUAL "Big-endian")
  set(ASM_BYTE_ORDER "-mbig-endian")
endif()

# C Pre-Processor

set(CPP_FLAGS "-E -P -xc")
set(CPP_DEFINES ${LD_SCRIPT_PP_DEFINES})
cbuild_set_defines(CC CPP_DEFINES)
if(DEFINED LD_REGIONS AND NOT LD_REGIONS STREQUAL "")
  set(CPP_INCLUDES "-include \"${LD_REGIONS}\"")
endif()
set(CPP_ARGS_LD_SCRIPT "${CPP_FLAGS} ${CPP_DEFINES} ${CPP_INCLUDES} \"${LD_SCRIPT}\" -o \"${LD_SCRIPT_PP}\"")
separate_arguments(CPP_ARGS_LD_SCRIPT NATIVE_COMMAND ${CPP_ARGS_LD_SCRIPT})

# C Compiler

set(CC_CPU "${CLANG_CPU}")
set(CC_DEFINES ${ASM_DEFINES})
set(CC_BYTE_ORDER ${ASM_BYTE_ORDER})
set(CC_FLAGS "--target=${CLANG_ARCH}-none-eabi --sysroot=${TOOLCHAIN_ROOT}/../lib/clang-runtimes/arm-none-eabi/${CLANG_ARCH}${CLANG_ARCH_SUFFIX}")
set(CC_OPTIONS_FLAGS)
cbuild_set_options_flags(CC "${OPTIMIZE}" "${DEBUG}" "${WARNINGS}" "${LANGUAGE_CC}" CC_OPTIONS_FLAGS)

if(SECURE STREQUAL "Secure")
  set(CC_SECURE "-mcmse")
else()
  set(CC_SECURE "")
endif()

if(BRANCHPROT STREQUAL "NO_BRANCHPROT")
  set(CC_BRANCHPROT "-mbranch-protection=none")
elseif(BRANCHPROT STREQUAL "BTI")
  set(CC_BRANCHPROT "-mbranch-protection=bti")
elseif(BRANCHPROT STREQUAL "BTI_SIGNRET")
  set(CC_BRANCHPROT "-mbranch-protection=bti+pac-ret")
endif()

# C++ Compiler

set(CXX_CPU "${CC_CPU}")
set(CXX_DEFINES "${CC_DEFINES}")
set(CXX_BYTE_ORDER "${CC_BYTE_ORDER}")
set(CXX_SECURE "${CC_SECURE}")
set(CXX_BRANCHPROT "${CC_BRANCHPROT}")
set(CXX_FLAGS "${CC_FLAGS}")
set(CXX_OPTIONS_FLAGS)
cbuild_set_options_flags(CXX "${OPTIMIZE}" "${DEBUG}" "${WARNINGS}" "${LANGUAGE_CXX}" CXX_OPTIONS_FLAGS)

# Linker

set(LD_CPU ${CLANG_CPU})
set(_LS "-T ")

if(SECURE STREQUAL "Secure")
  set(LD_SECURE "-Wl,--cmse-implib -Wl,--out-implib=\"${OUT_DIR}/${CMSE_LIB}\"")
endif()

set(LD_FLAGS)
set(LD_OPTIONS_FLAGS)
cbuild_set_options_flags(LD "${OPTIMIZE}" "${DEBUG}" "${WARNINGS}" "" LD_OPTIONS_FLAGS)

# Group libraries for rescanning
set(LIB_FILES -Wl,--start-group ${LIB_FILES} -Wl,--end-group)

# ELF to HEX conversion
set (ELF2HEX -O ihex "${OUT_DIR}/$<TARGET_PROPERTY:${TARGET},OUTPUT_NAME>$<TARGET_PROPERTY:${TARGET},SUFFIX>" "${OUT_DIR}/${HEX_FILE}")

# ELF to BIN conversion
set (ELF2BIN -O binary "${OUT_DIR}/$<TARGET_PROPERTY:${TARGET},OUTPUT_NAME>$<TARGET_PROPERTY:${TARGET},SUFFIX>" "${OUT_DIR}/${BIN_FILE}")

# Set CMake variables for toolchain initialization
set(CMAKE_SYSTEM_NAME Generic)
set(CMAKE_CROSSCOMPILING TRUE)
set(CMAKE_TRY_COMPILE_TARGET_TYPE STATIC_LIBRARY)
set(CMAKE_ASM_COMPILER "${AS}")
set(CMAKE_C_COMPILER "${CC}")
set(CMAKE_CXX_COMPILER "${CXX}")
set(CMAKE_OBJCOPY "${OC}")
set(CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR}/CMakeASM")
